
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=12, name="small_balls", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, ub=12, name="large_balls", vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 5*x1 + 2*x2
    model.setObjective(5*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 20, name="total_balls")
    model.addConstr(x1 >= 6, name="min_small_balls")
    model.addConstr(x2 >= 5, name="min_large_balls")
    model.addConstr(x1 <= 12, name="max_small_balls")
    model.addConstr(x2 <= 12, name="max_large_balls")

    # Update model
    model.update()

    # Solve the problem
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal score: {model.objVal}")
        print(f"Throw {x1.varValue} small balls and {x2.varValue} large balls.")
    else:
        print("The problem is infeasible.")

solve_problem()
