
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("train_ticket_optimization")

# Create variables
general_class = m.addVar(lb=0, vtype=GRB.INTEGER, name="general_class")
sleeper_class = m.addVar(lb=0, vtype=GRB.INTEGER, name="sleeper_class")

# Set objective function
m.setObjective(80 * general_class + 200 * sleeper_class, GRB.MAXIMIZE)

# Add constraints
m.addConstr(general_class + sleeper_class <= 400, "capacity")
m.addConstr(sleeper_class >= 50, "min_sleeper")
m.addConstr(general_class >= 1.5 * sleeper_class, "general_preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"General class tickets: {general_class.x}")
    print(f"Sleeper class tickets: {sleeper_class.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

