
from gurobipy import *

# Create a model
m = Model("Train_Ticket_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="sleeper_class_tickets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="general_class_tickets")

# Set objective function
m.setObjective(200*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 400, "total_passengers")
m.addConstr(x1 >= 50, "minimum_sleeper_class")
m.addConstr(x2 >= 1.5*x1, "general_vs_sleeper_ratio")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sleeper class tickets: {x1.x}")
    print(f"General class tickets: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 80*x2.x}")
else:
    print("No optimal solution found.")
