
import gurobi

def solve_train_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="sleeper_class_tickets", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="general_class_tickets", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize profit
    model.setObjective(200 * x1 + 80 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 400, name="total_passengers")
    model.addConstr(x1 >= 50, name="min_sleeper_class")
    model.addConstr(x2 >= 1.5 * x1, name="general_vs_sleeper")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Sleeper class tickets: {x1.varValue}")
        print(f"General class tickets: {x2.varValue}")
        print(f"Max profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_train_ticket_problem()
