
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Optimization")

# Create variables
energy_investment = m.addVar(name="energy_investment")
travel_investment = m.addVar(name="travel_investment")

# Set objective function
m.setObjective(0.32 * energy_investment + 0.20 * travel_investment, GRB.MAXIMIZE)

# Add constraints
m.addConstr(energy_investment + travel_investment == 10000000, "Total_Investment")
m.addConstr(energy_investment >= 0.25 * 10000000, "Min_Energy_Investment")
m.addConstr(travel_investment <= 0.50 * 10000000, "Max_Travel_Investment")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal ROI: ${m.objVal}")
    print(f"Energy Sector Investment: ${energy_investment.x}")
    print(f"Travel Sector Investment: ${travel_investment.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

