
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Problem")

# Define variables
x1 = model.addVar(name="Energy_Sector", lb=0)  # Amount invested in the energy sector
x2 = model.addVar(name="Travel_Sector", lb=0)  # Amount invested in the travel sector

# Objective function: Maximize 0.32*x1 + 0.20*x2
model.setObjective(0.32 * x1 + 0.20 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 == 10000000, name="Total_Investment")  # Total investment is $10 million
model.addConstr(x1 >= 0.25 * 10000000, name="Min_Energy_Sector")  # At least 25% in the energy sector
model.addConstr(x2 <= 0.50 * 10000000, name="Max_Travel_Sector")  # At most 50% in the travel sector

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Amount invested in the energy sector: ${x1.varValue}")
    print(f"Amount invested in the travel sector: ${x2.varValue}")
    print(f"Total return: ${0.32 * x1.varValue + 0.20 * x2.varValue}")
else:
    print("The model is infeasible.")
