
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Pierre's E-commerce Optimization")

# Create variables
sandals = m.addVar(vtype=GRB.INTEGER, name="sandals")
slippers = m.addVar(vtype=GRB.INTEGER, name="slippers")

# Set objective function
m.setObjective(70 * sandals + 30 * slippers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(sandals >= 3 * slippers, "demand_constraint")
m.addConstr(50 * sandals + 20 * slippers <= 3000, "budget_constraint")
m.addConstr(sandals >= 0, "non_negativity_sandals")
m.addConstr(slippers >= 0, "non_negativity_slippers")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of sandals to buy: {sandals.x}")
    print(f"Number of slippers to buy: {slippers.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

