
from gurobipy import *

# Create a new model
m = Model("Pierre_e-commerce")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="sandals")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="slippers")

# Set the objective function
m.setObjective(70*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 3*x2, "demand_ratio")
m.addConstr(50*x1 + 20*x2 <= 3000, "budget_constraint")
m.addConstr(x1 >= 0, "non_neg_sandals")
m.addConstr(x2 >= 0, "non_neg_slippers")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of sandals: {x1.x}")
    print(f"Number of slippers: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
