
import gurobi

def solve_pierre_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='sandals', lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='slippers', lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(70*x1 + 30*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 3*x2, name='demand_constraint')
    model.addConstr(50*x1 + 20*x2 <= 3000, name='investment_constraint')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: sandals = {x1.varValue}, slippers = {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_pierre_problem()
