
import gurobipy as gp

# Create a new model
model = gp.Model("puzzle_production")

# Create variables
small_puzzles = model.addVar(vtype=gp.GRB.INTEGER, name="small_puzzles")
large_puzzles = model.addVar(vtype=gp.GRB.INTEGER, name="large_puzzles")

# Set objective function
model.setObjective(8 * small_puzzles + 12 * large_puzzles, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * small_puzzles + 15 * large_puzzles <= 600, "cutting_time")
model.addConstr(20 * small_puzzles + 30 * large_puzzles <= 1000, "qc_time")
model.addConstr(small_puzzles >= 0, "small_puzzles_nonnegative")  # Ensure non-negative values
model.addConstr(large_puzzles >= 0, "large_puzzles_nonnegative") # Ensure non-negative values


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of small puzzles: {small_puzzles.x}")
    print(f"Number of large puzzles: {large_puzzles.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

