
from gurobipy import *

# Create a new model
m = Model("Puzzle_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="small_puzzles", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="large_puzzles", lb=0)

# Set the objective function
m.setObjective(8*x1 + 12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 600, "cutting_time")
m.addConstr(20*x1 + 30*x2 <= 1000, "quality_checking_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
