
import gurobi

def solve_puzzle_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="small_puzzles")
    x2 = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="large_puzzles")

    # Set the objective function
    model.setObjective(8*x1 + 12*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x1 + 15*x2 <= 600, name="cutting_time")
    model.addConstr(20*x1 + 30*x2 <= 1000, name="quality_checking_time")
    model.addConstr(x1 >= 0, name="non_negative_small")
    model.addConstr(x2 >= 0, name="non_negative_large")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of small puzzles: {x1.varValue}")
        print(f"Number of large puzzles: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_puzzle_problem()
