
import gurobipy as gp

# Create a new model
m = gp.Model("SeasoningMix")

# Create variables
x1 = m.addVar(lb=0, name="Seasoning_A") # kg of seasoning A
x2 = m.addVar(lb=0, name="Seasoning_B") # kg of seasoning B

# Set objective function
m.setObjective(1.5 * x1 + 3 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * x1 + x2 >= 5, "PepperConstraint")
m.addConstr(x1 + 4 * x2 >= 6, "SaltConstraint")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Seasoning A: {x1.x:.2f} kg")
    print(f"Seasoning B: {x2.x:.2f} kg")

