
from gurobipy import *

# Create a new model
m = Model("seasoning_mixture")

# Add variables
x1 = m.addVar(name="Seasoning_A", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Seasoning_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(1.5*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + x2 >= 5, name="pepper_constraint")
m.addConstr(x1 + 4*x2 >= 6, name="salt_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Seasoning A: {x1.x} kg")
    print(f"Seasoning B: {x2.x} kg")
    print(f"Total cost: ${1.5*x1.x + 3*x2.x:.2f}")
else:
    print("No optimal solution found.")
