
import gurobi

def solve_seasoning_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="Seasoning_A", lb=0, ub=float('inf'))
    x2 = model.addVar(name="Seasoning_B", lb=0, ub=float('inf'))

    # Objective function: minimize 1.5x1 + 3x2
    model.setObjective(1.5 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x1 + x2 >= 5, name="pepper_constraint")
    model.addConstr(x1 + 4 * x2 >= 6, name="salt_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of Seasoning A: {x1.varValue} kg")
        print(f"Optimal amount of Seasoning B: {x2.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_seasoning_problem()
