
from gurobipy import Model, GRB

# Create a new model
m = Model("bus_seating")

# Create variables
bottom_deck = m.addVar(vtype=GRB.INTEGER, name="bottom_deck")
top_deck = m.addVar(vtype=GRB.INTEGER, name="top_deck")

# Set objective function
m.setObjective(25 * bottom_deck + 35 * top_deck, GRB.MAXIMIZE)

# Add constraints
m.addConstr(bottom_deck + top_deck <= 50, "capacity")
m.addConstr(bottom_deck >= 10, "min_bottom")
m.addConstr(top_deck >= 2 * bottom_deck, "top_preference")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of bottom deck seats: {bottom_deck.x}")
    print(f"Number of top deck seats: {top_deck.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

