
from gurobipy import *

# Create a model
m = Model("bus_seating")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="bottom_deck_seats")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="top_deck_seats")

# Set objective function
m.setObjective(25*x1 + 35*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 50, "total_seats")
m.addConstr(x1 >= 10, "min_bottom_deck_seats")
m.addConstr(x2 >= 2*x1, "top_vs_bottom_seats")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bottom deck seats: {x1.x}")
    print(f"Top deck seats: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
