
import gurobi

def solve_bus_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bottom_deck_seats", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="top_deck_seats", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 25*x1 + 35*x2
    model.setObjective(25*x1 + 35*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 50, name="total_seats")
    model.addConstr(x1 >= 10, name="min_bottom_deck_seats")
    model.addConstr(x2 >= 2*x1, name="top_vs_bottom_deck")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: bottom deck seats = {x1.varValue}, top deck seats = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_bus_seating_problem()
