
import gurobipy as gp

# Create a new model
m = gp.Model("Litchi_Shipping")

# Create variables
boat_trips = m.addVar(vtype=gp.GRB.INTEGER, name="boat_trips")
plane_trips = m.addVar(vtype=gp.GRB.INTEGER, name="plane_trips")


# Set objective function
m.setObjective(500 * boat_trips + 200 * plane_trips, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5000 * boat_trips + 3000 * plane_trips <= 200000, "budget_constraint")
m.addConstr(boat_trips <= plane_trips, "trips_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of boat trips: {boat_trips.x}")
    print(f"Number of plane trips: {plane_trips.x}")
    print(f"Total boxes of litchis shipped: {500 * boat_trips.x + 200 * plane_trips.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

