
from gurobipy import *

# Create a new model
m = Model("Litchi_Farm")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="boat_trips")
x2 = m.addVar(vtype=GRB.INTEGER, name="cargo_plane_trips")

# Set the objective function
m.setObjective(500*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5000*x1 + 3000*x2 <= 200000, "budget")
m.addConstr(x1 <= x2, "trip_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of boat trips: {x1.x}")
    print(f"Number of cargo plane trips: {x2.x}")
    print(f"Total boxes delivered: {500*x1.x + 200*x2.x}")
else:
    print("No optimal solution found")
