
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="boat_trips", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(lb=0, name="cargo_plane_trips", vtype=gurobi.GRB.INTEGER)

# Objective function: Maximize 500x1 + 200x2
model.setObjective(500*x1 + 200*x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= x2, name="boat_cargo_constraint")
model.addConstr(5000*x1 + 3000*x2 <= 200000, name="budget_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of boat trips: {x1.varValue}")
    print(f"Number of cargo plane trips: {x2.varValue}")
    print(f"Total boxes delivered: {500*x1.varValue + 200*x2.varValue}")
else:
    print("No optimal solution found.")
