
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("mia_clothing")

# Create variables
skirts = m.addVar(vtype=GRB.CONTINUOUS, name="skirts")
coats = m.addVar(vtype=GRB.CONTINUOUS, name="coats")

# Set objective function
m.setObjective(300 * skirts + 500 * coats, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * skirts + 2 * coats <= 25, "sewing_machine")
m.addConstr(5 * skirts + 3.5 * coats <= 35, "embroidery_machine")
m.addConstr(skirts >= 0, "skirts_nonnegative")
m.addConstr(coats >= 0, "coats_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal weekly production:")
    print(f"  Skirts: {skirts.x}")
    print(f"  Coats: {coats.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

