
from gurobipy import *

# Create a new model
m = Model("Mia_Clothing")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="skirts")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="coats")

# Set the objective function
m.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 25, "sewing_machine")
m.addConstr(5*x1 + 3.5*x2 <= 35, "embroidery_machine")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Skirts: {x1.x}, Coats: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
