
import gurobi

def solve_production_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="skirts")  # number of skirts
    x2 = model.addVar(lb=0, name="coats")  # number of coats

    # Define the objective function
    model.setObjective(300 * x1 + 500 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 2 * x2 <= 25, name="sewing_machine_constraint")
    model.addConstr(5 * x1 + 3.5 * x2 <= 35, name="embroidery_machine_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal production levels:")
        print(f"Skirts: {x1.varValue}")
        print(f"Coats: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_production_problem()
