
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("berry_farm")

# Create variables
cranberries = m.addVar(lb=0, name="cranberries")
bilberries = m.addVar(lb=0, name="bilberries")

# Set objective function
m.setObjective(66 * cranberries + 73 * bilberries, GRB.MAXIMIZE)

# Add constraints
m.addConstr(cranberries + bilberries <= 250, "land_constraint")
m.addConstr(25 * cranberries + 30 * bilberries <= 9000, "watering_constraint")
m.addConstr(5 * cranberries + 4 * bilberries <= 600, "labor_constraint")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Cranberries to plant: {cranberries.x} acres")
    print(f"Bilberries to plant: {bilberries.x} acres")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

