
from gurobipy import *

# Create a new model
m = Model("Berry_Farm_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="acres_of_cranberries")
x2 = m.addVar(lb=0, name="acres_of_bilberries")

# Set the objective function
m.setObjective(66*x1 + 73*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 <= 600, "labor_constraint")
m.addConstr(25*x1 + 30*x2 <= 9000, "watering_cost_constraint")
m.addConstr(x1 + x2 <= 250, "total_land_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of cranberries: {x1.x}")
    print(f"Acres of bilberries: {x2.x}")
    print(f"Maximum profit: ${66*x1.x + 73*x2.x:.2f}")
else:
    print("No optimal solution found")
