
import gurobipy as gp

# Create a new model
m = gp.Model("berry_farm")

# Define the variables
x1 = m.addVar(name="cranberries", lb=0)
x2 = m.addVar(name="bilberries", lb=0)

# Define the objective function
m.setObjective(66*x1 + 73*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 250, name="land_constraint")
m.addConstr(25*x1 + 30*x2 <= 9000, name="watering_cost_constraint")
m.addConstr(5*x1 + 4*x2 <= 600, name="labor_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Acres of cranberries: {x1.varValue}")
    print(f"Acres of bilberries: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
