
import gurobipy as gp

# Create a new model
m = gp.Model("John's Diet")

# Create variables
pears = m.addVar(lb=0, name="pears")  # Pounds of pears
broccoli = m.addVar(lb=0, name="broccoli")  # Pounds of broccoli

# Set objective function: Minimize cost
m.setObjective(6 * pears + 8 * broccoli, gp.GRB.MINIMIZE)

# Add constraints for nutrient requirements
m.addConstr(2 * pears + 4 * broccoli >= 15, "calcium")
m.addConstr(5 * pears + 3 * broccoli >= 20, "potassium")
m.addConstr(3 * pears + 6 * broccoli >= 17, "magnesium")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Pounds of pears: {pears.x:.2f}")
    print(f"Pounds of broccoli: {broccoli.x:.2f}")

