
from gurobipy import *

# Create a new model
m = Model("Johns_Diet")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="pounds_of_pears")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="pounds_of_broccoli")

# Set the objective function
m.setObjective(6*x1 + 8*x2, GRB.MINIMIZE)

# Add the constraints
m.addConstr(2*x1 + 4*x2 >= 15, "calcium_requirement")
m.addConstr(5*x1 + 3*x2 >= 20, "potassium_requirement")
m.addConstr(3*x1 + 6*x2 >= 17, "magnesium_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Pounds of pears: {x1.x}")
    print(f"Pounds of broccoli: {x2.x}")
    print(f"Total cost: ${6*x1.x + 8*x2.x:.2f}")
else:
    print("No optimal solution found.")

