
import gurobipy as gp

# Create a new model
model = gp.Model("Nutrition Problem")

# Define the variables
x1 = model.addVar(name="pears", lb=0)  # Pounds of pears
x2 = model.addVar(name="broccoli", lb=0)  # Pounds of broccoli

# Define the objective function
model.setObjective(6 * x1 + 8 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * x1 + 4 * x2 >= 15, name="calcium_requirement")
model.addConstr(5 * x1 + 3 * x2 >= 20, name="potassium_requirement")
model.addConstr(3 * x1 + 6 * x2 >= 17, name="magnesium_requirement")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal amount of pears: {x1.varValue} pounds")
    print(f"Optimal amount of broccoli: {x2.varValue} pounds")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
