
import gurobipy as gp

# Create a new model
model = gp.Model("Ice Cream Optimization")

# Create variables
vanilla = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vanilla")
chocolate = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chocolate")


# Set objective function
model.setObjective(2 * vanilla + 3 * chocolate, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(vanilla >= 20, "min_vanilla")
model.addConstr(vanilla <= 50, "max_vanilla")
model.addConstr(chocolate >= 25, "min_chocolate")
model.addConstr(chocolate <= 60, "max_chocolate")
model.addConstr(vanilla + chocolate <= 80, "total_cones")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {model.objVal}")
    print(f"Vanilla cones: {vanilla.x}")
    print(f"Chocolate cones: {chocolate.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

