
from gurobipy import *

# Create a new model
model = Model("IceCreamOptimization")

# Define variables
x1 = model.addVar(lb=20, ub=50, vtype=GRB.INTEGER, name="vanilla_cones")
x2 = model.addVar(lb=25, ub=60, vtype=GRB.INTEGER, name="chocolate_cones")

# Set the objective function
model.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 80, "total_cones_limit")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vanilla cones: {x1.x}")
    print(f"Chocolate cones: {x2.x}")
    print(f"Total profit: {model.objVal}")
else:
    print("No optimal solution found")
