
import gurobipy as gp

# Create a new model
model = gp.Model("IceCreamProduction")

# Define the variables
x1 = model.addVar(lb=20, ub=50, name="vanilla_cones")  # vanilla ice cream cones
x2 = model.addVar(lb=25, ub=60, name="chocolate_cones")  # chocolate ice cream cones

# Objective function: maximize profit
model.setObjective(2*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Additional constraint: total cones not exceeding 80
model.addConstraint(x1 + x2 <= 80)

# Solve the model
model.solve()

# Check if the model is solved successfully
if model.status == gp.GRB.Status.OPTIMAL:
    print("Optimal Solution:")
    print(f"Vanilla ice cream cones: {x1.varValue}")
    print(f"Chocolate ice cream cones: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or has no solution.")
