
import gurobipy as gp

# Create a new model
m = gp.Model("Supplement_Mix")

# Create variables
orange = m.addVar(nonnegative=True, name="orange")  # Servings of orange drink
apple = m.addVar(nonnegative=True, name="apple")  # Servings of apple drink


# Set objective function: Minimize cost
m.setObjective(8 * orange + 5 * apple, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * orange + 6 * apple >= 13, "Fiber")  # Fiber constraint
m.addConstr(5 * orange + 3 * apple >= 13, "Iron")  # Iron constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Orange servings: {orange.x:.2f}")
    print(f"Apple servings: {apple.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

