
from gurobipy import *

# Create a new model
m = Model("Fiber_and_Iron")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="orange_flavored_drink")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="apple_flavored_drink")

# Set the objective function
m.setObjective(8*x1 + 5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 6*x2 >= 13, "fiber_requirement")
m.addConstr(5*x1 + 3*x2 >= 13, "iron_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of servings of orange flavored drink: {x1.x}")
    print(f"Number of servings of apple flavored drink: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
