
import gurobipy as gp

# Create a new model
model = gp.Model("Fiber_and_Iron_Optimization")

# Define the variables
x1 = model.addVar(name="orange_flavored_drink", lb=0)  # orange flavored drink (servings)
x2 = model.addVar(name="apple_flavored_drink", lb=0)  # apple flavored drink (servings)

# Define the objective function
model.setObjective(8 * x1 + 5 * x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(4 * x1 + 6 * x2 >= 13, name="fiber_intake")  # fiber intake
model.addConstr(5 * x1 + 3 * x2 >= 13, name="iron_intake")  # iron intake

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Orange flavored drink: {x1.varValue} servings")
    print(f"Apple flavored drink: {x2.varValue} servings")
    print(f"Total cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
