
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("animal_catching")

# Create variables
fish = m.addVar(vtype=GRB.INTEGER, name="fish")
bird = m.addVar(vtype=GRB.INTEGER, name="bird")

# Set objective function
m.setObjective(4 * fish + 6 * bird, GRB.MAXIMIZE)

# Add constraints
m.addConstr(fish >= 6, "min_fish")
m.addConstr(bird >= 2, "min_bird")
m.addConstr(fish <= 9, "max_fish")
m.addConstr(bird <= 4, "max_bird")
m.addConstr(fish + bird <= 12, "total_animals")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Fish = {fish.x}, Bird = {bird.x}")
    print(f"Maximum points: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

