
from gurobipy import *

# Create a new model
m = Model("Animal_Catching")

# Add variables
x1 = m.addVar(lb=6, ub=9, vtype=GRB.INTEGER, name="fish_caught")
x2 = m.addVar(lb=2, ub=4, vtype=GRB.INTEGER, name="birds_caught")

# Set the objective function
m.setObjective(4*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 12, "total_animals")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fish caught: {x1.x}")
    print(f"Birds caught: {x2.x}")
    print(f"Total points: {4*x1.x + 6*x2.x}")
else:
    print("No optimal solution found")
