
import gurobi as gp

# Create a new model
model = gp.Model("fish_bird_catch")

# Define the variables
x1 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="fishes")
x2 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="birds")

# Set bounds and constraints
x1.lb = 6
x2.lb = 2
x1.ub = 9
x2.ub = 4

# Add constraints
model.addConstr(x1 <= 9, name="max_fishes")
model.addConstr(x2 <= 4, name="max_birds")
model.addConstr(x1 + x2 <= 12, name="total_animals")

# Objective function
model.setObjective(4 * x1 + 6 * x2, gp.GRB.MAXIMIZE)

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Catch {x1.varValue} fishes and {x2.varValue} birds to maximize points.")
else:
    print("No optimal solution found.")
