
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bubble_tea")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # almond bubble tea
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # ginger bubble tea


# Set objective function
m.setObjective(5*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 120, "almond_demand")
m.addConstr(x2 <= 200, "ginger_demand")
m.addConstr(x1 + x2 <= 300, "total_production")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Almond bubble tea: {x1.x}")
    print(f"Ginger bubble tea: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

