
from gurobipy import *

# Create a new model
model = Model("Bubble_Tea_Optimization")

# Define variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="almond_bubble_tea")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ginger_bubble_tea")

# Set the objective function
model.setObjective(5*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 120, "almond_limit")
model.addConstr(x2 <= 200, "ginger_limit")
model.addConstr(x1 + x2 <= 300, "total_production_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
