
import gurobi

def solve_bubble_tea_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="almond_bubble_tea")
    x2 = model.addVar(lb=0, name="ginger_bubble_tea")

    # Define the objective function
    model.setObjective(5 * x1 + 9 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(x1 <= 120, name="almond_demand_constraint")
    model.addConstr(x2 <= 200, name="ginger_demand_constraint")
    model.addConstr(x1 + x2 <= 300, name="total_production_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Almond bubble tea bottles: {x1.varValue}")
        print(f"Ginger bubble tea bottles: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bubble_tea_problem()
