
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Luke's Farm")

# Create variables
carrots = m.addVar(name="carrots")
pumpkins = m.addVar(name="pumpkins")

# Set objective function
m.setObjective(300 * carrots + 500 * pumpkins, GRB.MAXIMIZE)

# Add constraints
m.addConstr(carrots + pumpkins <= 200, "Total land")
m.addConstr(carrots <= 2 * pumpkins, "Carrot to pumpkin ratio")
m.addConstr(carrots >= 25, "Minimum carrots")
m.addConstr(pumpkins >= 20, "Minimum pumpkins")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Plant {carrots.x} hectares of carrots")
    print(f"Plant {pumpkins.x} hectares of pumpkins")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

