
from gurobipy import *

# Create a new model
m = Model("Luke_Farming_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hectares_of_carrots")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hectares_of_pumpkins")

# Set the objective function
m.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200, "total_area")
m.addConstr(x1 >= 25, "min_carrots")
m.addConstr(x2 >= 20, "min_pumpkins")
m.addConstr(x1 <= 2*x2, "carrot_to_pumpkin_ratio")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
