
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="carrots")  # hectares of carrots
x2 = model.addVar(lb=0, name="pumpkins")  # hectares of pumpkins

# Set the objective function
model.setObjective(300*x1 + 500*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 200, name="total_hectares")
model.addConstr(x1 <= 2*x2, name="carrots_to_pumpkins_ratio")
model.addConstr(x1 >= 25, name="min_carrots")
model.addConstr(x2 >= 20, name="min_pumpkins")

# Update the model
model.update()

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Hectares of carrots: {x1.varValue}")
    print(f"Hectares of pumpkins: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
