
import gurobipy as gp

# Create a new model
model = gp.Model("NovaNetwork")

# Create variables
ring = model.addVar(vtype=gp.GRB.INTEGER, name="ring")
tree = model.addVar(vtype=gp.GRB.INTEGER, name="tree")
mesh = model.addVar(vtype=gp.GRB.INTEGER, name="mesh")


# Set objective function
model.setObjective(2000 * ring + 4000 * tree + 8000 * mesh, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(50 * ring + 30 * tree + 100 * mesh <= 2000, "workstations")
model.addConstr(20 * ring + 15 * tree + 50 * mesh <= 500, "servers")
model.addConstr(10 * ring + 7 * tree + 30 * mesh <= 300, "switches")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Ring layouts: {ring.x:.0f}")
    print(f"Tree layouts: {tree.x:.0f}")
    print(f"Mesh layouts: {mesh.x:.0f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

