
import gurobipy as gp

# Create a new model
model = gp.Model("Network_Optimization")

# Define variables
x1 = model.addVar(name="ring_layouts", lb=0, vtype=gp.GRB.INTEGER)  # Number of ring layouts
x2 = model.addVar(name="tree_layouts", lb=0, vtype=gp.GRB.INTEGER)  # Number of tree layouts
x3 = model.addVar(name="mesh_layouts", lb=0, vtype=gp.GRB.INTEGER)  # Number of mesh layouts

# Objective function: Maximize profit
model.setObjective(2000*x1 + 4000*x2 + 8000*x3, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(50*x1 + 30*x2 + 100*x3 <= 2000, name="workstations")  # Workstations constraint
model.addConstr(20*x1 + 15*x2 + 50*x3 <= 500, name="servers")  # Servers constraint
model.addConstr(10*x1 + 7*x2 + 30*x3 <= 300, name="switches")  # Switches constraint

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Ring Layouts: {x1.varValue}")
    print(f"Tree Layouts: {x2.varValue}")
    print(f"Mesh Layouts: {x3.varValue}")
    print(f"Maximum Profit: {model.objVal}")
else:
    print("No optimal solution found.")
