
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("computer_store")

# Create variables
laptops = m.addVar(lb=0, vtype=GRB.INTEGER, name="laptops")
desktops = m.addVar(lb=0, vtype=GRB.INTEGER, name="desktops")


# Set objective function
m.setObjective(210 * laptops + 160 * desktops, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500 * laptops + 400 * desktops <= 20000, "budget")
m.addConstr(laptops >= 20, "min_laptops")
m.addConstr(laptops <= 35, "max_laptops")
m.addConstr(desktops <= (1/3) * laptops, "desktop_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of laptops to sell: {laptops.x}")
    print(f"Number of desktops to sell: {desktops.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

