
from gurobipy import *

# Create a new model
m = Model("Computer_Store_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="laptops")
x2 = m.addVar(vtype=GRB.INTEGER, name="desktops")

# Set objective function
m.setObjective(210*x1 + 160*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*x1 + 400*x2 <= 20000, "budget_constraint")
m.addConstr(x1 >= 20, "min_laptops")
m.addConstr(x1 <= 35, "max_laptops")
m.addConstr(x2 <= (1/3)*x1, "desktops_vs_laptops")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Laptops to sell: {x1.x}")
    print(f"Desktops to sell: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
