
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=20, ub=35, name="laptops")  # At least 20, at most 35 laptops
    x2 = model.addVar(lb=0, name="desktops")  # Non-negative number of desktops

    # Objective function: Maximize 210*x1 + 160*x2
    model.setObjective(210*x1 + 160*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(500*x1 + 400*x2 <= 20000, name="budget_constraint")  # Budget constraint
    model.addConstr(x2 <= (1/3)*x1, name="laptop_desktop_ratio")  # Desktop ratio constraint

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Laptops to sell: {x1.varValue}")
        print(f"Desktops to sell: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
